<?php
error_reporting(E_ALL);
ini_set('display_errors', 'On');
//Author: Constantin Nelu
//Company: YBOMedia.ro
//Version: 1

// Settings

$token =
    "3014174-3031442-KK0L3W5HNV5VXE4FPIODGRYPCBW3K2FR6KERM87FEG0TDR518UWJ74QGJGWFTRP1";
$url = "https://api.baselinker.com/connector.php";

$dateString = "2023-06-01";
$endDateString = '2023-07-01';
$unixTimestamp = strtotime($dateString);
$endUnixTimestamp = strtotime($endDateString);

// functions
function getBlInvoices($date_from, $invoice_id, $invoice_specific_id)
{
    global $token;
    global $url;

    $methodParams = [
        "date_from" => $date_from,
    ];

    if ($invoice_id !== 0) {
        $methodParams = [
            "id_from" => $invoice_id,
        ];
    }

    if ($invoice_specific_id !== 0) {
        $methodParams = [
            "invoice_id" => $invoice_specific_id,
        ];
    }
    $apiParams = [
        "token" => $token,
        "method" => "getInvoices",
        "parameters" => json_encode($methodParams),
    ];

    $options = [
        CURLOPT_POSTFIELDS => http_build_query($apiParams),
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true, // return web page
        CURLOPT_HEADER => false, // don't return headers
        CURLOPT_FOLLOWLOCATION => true, // follow redirects
        CURLOPT_MAXREDIRS => 10, // stop after 10 redirects
        CURLOPT_ENCODING => "", // handle compressed
        CURLOPT_USERAGENT => "test", // name of client
        CURLOPT_AUTOREFERER => true, // set referrer on redirect
        CURLOPT_CONNECTTIMEOUT => 120, // time-out on connect
        CURLOPT_TIMEOUT => 120, // time-out on response
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, $options);

    $content = curl_exec($ch);
    curl_close($ch);
    $ordArr = json_decode($content, true);

    return $ordArr["invoices"];
}

// END OF FUNCTIONS

// Prepare array and set limit to loop the call untill we get all invoices for that specified period.
$allInvoices = [];
$limit = 100;
$id_from = 0;
$csvFilePath = "invoices.csv";

$columnHeaders = [
    "Col_SerieFactura=0",
    "Col_NRFactura=1",
    "Col_DataFactura=2",
    "Col_Scadenta=",
    "Col_Obs=21",
    "Col_CodClient=3",
    "Col_Moneda=4",
    "Col_Curs=5",
    "Col_Pret=6",
    "Col_Cant=11",
    "Col_Anulat=22",
    "Col_TIPTVA=8",
    "Col_IDArticol=10",
    "Col_DenPart=12",
    "Col_Localitate=15",
    "Col_CodFiscal=13",
    "Col_TipTranzactie=9",
    "Col_SimbolGest=24",
    "Col_PersoanaFizica=18",
    "Col_CodExternPart=",
    "Col_CodInternPart=",
    "Col_MarcaAgent=",
    "Col_TVA=",
    "Col_NrAviz=",
    "Col_EmisaDe=",
    "Col_CodPartTert=",
    "Col_Judet=16",
    "Col_Adresa=14",
    "Col_Tara=17",
];

// Open the CSV file for writing
$csvFile = fopen($csvFilePath, "w");
fputs($csvFile, "\xEF\xBB\xBF");
fputcsv($csvFile, $columnHeaders);

$stopOuterLoop = false;

while (!$stopOuterLoop) {
    sleep(1);

    $invoices = getBlInvoices($unixTimestamp, $id_from, 0);
    $skipRow = false;
    $lastInvoice = end($invoices);
    $end_id = $lastInvoice["invoice_id"];

    $allInvoices = array_merge($allInvoices, $invoices);

    foreach ($invoices as $invoice) {

        if($invoice['date_add'] > $endUnixTimestamp){
            $stopOuterLoop = true; // Set flag to stop the outer loop
            break; // Break the inner foreach loop
        } 

        $invoiceNumber =
                "BL" . str_pad(mt_rand(1, 9999999), 5, "0", STR_PAD_LEFT);
        foreach ($invoice["items"] as $item) {
            // Write each item as a CSV line

            $invoice_address = explode(", ", $invoice["invoice_city"]);

            if (empty($invoice["invoice_nip"])) {
                $customer_name = $invoice["invoice_fullname"];
                $cod_fiscal = 0;
                $persoana_fizica = "D";
            } else {
                $customer_name = $invoice["invoice_company"];
                $cod_fiscal = $invoice["invoice_nip"];
                $persoana_fizica = "N";
            }

            $quantity = 0;

            if ($invoice["type"] == "normal") {
                $price = $item["price_brutto"];
                $quantity = $item["quantity"];
                $vat = $item["price_brutto"] - $item["price_netto"];

            } elseif ($invoice["type"] == "correcting") {
                $oldInvoice = getBlInvoices(
                    0,
                    0,
                    $invoice["correcting_to_invoice_id"]
                );

                // Initialize the quantity adjustment for the correcting invoice
                $quantityAdjustment = 0;
                $matchFound = false;

                foreach ($oldInvoice as $oldInvoice) {
                    foreach ($oldInvoice["items"] as $oldItem) {
                        if (
                            $oldItem["sku"] === $item["sku"] ||
                            ($item["is_shipment"] && $oldItem["sku"] === "")
                        ) {
                            // For matching SKU or shipments with empty SKU, calculate the quantity adjustment
                            if ($oldItem["quantity"] !== $item["quantity"]) {
                                $quantityAdjustment =
                                    $item["quantity"] - $oldItem["quantity"];

                                $matchFound = true;
                                break; // Exit the loop since we found the match
                            } elseif (
                                $oldItem["quantity"] == $item["quantity"]
                            ) {
                                $skipRow = true;
                            }
                        }
                    }
                }

                if (!$matchFound) {
                    $quantity = $item["quantity"];
                } else {
                    // Adjust the quantity based on the calculated adjustment
                    $quantity = $item["quantity"] + $quantityAdjustment;
                }
            }

                $grossPrice = $item['price_brutto'];
                $vat = abs($grossPrice) - (abs($grossPrice) / 1.19);
            
                if ($grossPrice >= 0) {
                    $item['price_brutto'] = $grossPrice - $vat;
                } else {
                    $vat = -$vat; // Make sure vat is negative
                    $item['price_brutto'] = $grossPrice - $vat;
                }
            
            if ($skipRow === false) {
                if ($item["is_shipment"] === 1) {
                    $item["sku"] = "Ztransport";
                }

                if($quantity < 0){
                    $item['price_brutto'] = "-".$item['price_brutto'];
                    $vat = "-".$vat;
                }

                if ($item['sku'] == 'discount') {
                $item['price_brutto'] += $vat;
                $vat = 0;
                } 
                $rowData = [
                    preg_replace("/[0-9\s]/", "", $invoice["number"]),
                    $invoice["sub_id"],
                    date("d.m.Y", $invoice["date_add"]),
                    "",
                    "",
                    $invoiceNumber,
                    $invoice["currency"],
                    "1",
                    $item["price_brutto"] ?? "",
                    $quantity ?? "",
                    "",
                    1,
                    $item["sku"] ?? "",
                    $customer_name,
                    str_replace(',', ' ', $invoice["invoice_city"]),
                    $cod_fiscal,
                    1,
                    "EM",
                    $persoana_fizica,
                    "",
                    "",
                    "",
                    $vat,
                    "",
                    $invoice["issuer"] ?? "",
                    "",
                    $invoice_address[1],
                    $invoice["invoice_address"],
                    $invoice["invoice_country"],
                ];

                // Write the combined item and invoice details as a CSV line
                fputcsv($csvFile, $rowData);
            }
        }
    }

    if (count($invoices) < $limit) {
        break;
    }
    $id_from = $end_id + 1;
}
//--------------------------------------------------------------

fclose($csvFile);

?>
